"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    name: str,
    index_id: str,
    type_: str,
    configuration: Dict = None,
    description: str = None,
    schedule: str = None,
    role_arn: str = None,
    tags: List = None,
    client_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a data source that you use to with an Amazon Kendra index.  You specify a name, data source connector type and description for your data source. You also specify configuration information such as document metadata (author, source URI, and so on) and user context information.  CreateDataSource is a synchronous operation. The operation returns 200 if the data source was successfully created. Otherwise, an exception is raised.

    Args:
        name(str): A unique name for the data source. A data source name can't be changed without deleting and recreating the data source.
        index_id(str): The identifier of the index that should be associated with this data source.
        type_(str): The type of repository that contains the data source.
        configuration(Dict, optional): The connector configuration information that is required to access the repository. You can't specify the Configuration parameter when the Type parameter is set to CUSTOM. If you do, you receive a ValidationException exception. The Configuration parameter is required for all other data sources. Defaults to None.
        description(str, optional): A description for the data source. Defaults to None.
        schedule(str, optional): Sets the frequency that Amazon Kendra will check the documents in your repository and update the index. If you don't set a schedule Amazon Kendra will not periodically update the index. You can call the StartDataSourceSyncJob operation to update the index. You can't specify the Schedule parameter when the Type parameter is set to CUSTOM. If you do, you receive a ValidationException exception. Defaults to None.
        role_arn(str, optional): The Amazon Resource Name (ARN) of a role with permission to access the data source. For more information, see IAM Roles for Amazon Kendra. You can't specify the RoleArn parameter when the Type parameter is set to CUSTOM. If you do, you receive a ValidationException exception. The RoleArn parameter is required for all other data sources. Defaults to None.
        tags(List, optional): A list of key-value pairs that identify the data source. You can use the tags to identify and organize your resources and to control access to resources. Defaults to None.
        client_token(str, optional): A token that you provide to identify the request to create a data source. Multiple calls to the CreateDataSource operation with the same client token will create only one data source. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.kendra.data_source.init.create(
                ctx, name=value, index_id=value, type_=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.kendra.data_source.init.create name=value, index_id=value, type_=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="kendra",
        operation="create_data_source",
        op_kwargs={
            "Name": name,
            "IndexId": index_id,
            "Type": type_,
            "Configuration": configuration,
            "Description": description,
            "Schedule": schedule,
            "RoleArn": role_arn,
            "Tags": tags,
            "ClientToken": client_token,
        },
    )


async def delete(hub, ctx, id_: str, index_id: str) -> None:
    r"""
    **Autogenerated function**

    Deletes an Amazon Kendra data source. An exception is not thrown if the data source is already being deleted. While the data source is being deleted, the Status field returned by a call to the DescribeDataSource operation is set to DELETING. For more information, see Deleting Data Sources.

    Args:
        id_(str): The unique identifier of the data source to delete.
        index_id(str): The unique identifier of the index associated with the data source.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.kendra.data_source.init.delete(ctx, id_=value, index_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.kendra.data_source.init.delete id_=value, index_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="kendra",
        operation="delete_data_source",
        op_kwargs={"Id": id_, "IndexId": index_id},
    )


async def describe(hub, ctx, id_: str, index_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Gets information about a Amazon Kendra data source.

    Args:
        id_(str): The unique identifier of the data source to describe.
        index_id(str): The identifier of the index that contains the data source.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.kendra.data_source.init.describe(ctx, id_=value, index_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.kendra.data_source.init.describe id_=value, index_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="kendra",
        operation="describe_data_source",
        op_kwargs={"Id": id_, "IndexId": index_id},
    )


async def list_all(
    hub, ctx, index_id: str, next_token: str = None, max_results: int = None
) -> Dict:
    r"""
    **Autogenerated function**

    Lists the data sources that you have created.

    Args:
        index_id(str): The identifier of the index that contains the data source.
        next_token(str, optional): If the previous response was incomplete (because there is more data to retrieve), Amazon Kendra returns a pagination token in the response. You can use this pagination token to retrieve the next set of data sources (DataSourceSummaryItems). . Defaults to None.
        max_results(int, optional): The maximum number of data sources to return. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.kendra.data_source.init.list_all(ctx, index_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.kendra.data_source.init.list_all index_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="kendra",
        operation="list_data_sources",
        op_kwargs={
            "IndexId": index_id,
            "NextToken": next_token,
            "MaxResults": max_results,
        },
    )


async def update(
    hub,
    ctx,
    id_: str,
    index_id: str,
    name: str = None,
    configuration: Dict = None,
    description: str = None,
    schedule: str = None,
    role_arn: str = None,
) -> None:
    r"""
    **Autogenerated function**

    Updates an existing Amazon Kendra data source.

    Args:
        id_(str): The unique identifier of the data source to update.
        name(str, optional): The name of the data source to update. The name of the data source can't be updated. To rename a data source you must delete the data source and re-create it. Defaults to None.
        index_id(str): The identifier of the index that contains the data source to update.
        configuration(Dict, optional): Configuration information for a Amazon Kendra data source. Defaults to None.
        description(str, optional): The new description for the data source. Defaults to None.
        schedule(str, optional): The new update schedule for the data source. Defaults to None.
        role_arn(str, optional): The Amazon Resource Name (ARN) of the new role to use when the data source is accessing resources on your behalf. Defaults to None.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.kendra.data_source.init.update(ctx, id_=value, index_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.kendra.data_source.init.update id_=value, index_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="kendra",
        operation="update_data_source",
        op_kwargs={
            "Id": id_,
            "Name": name,
            "IndexId": index_id,
            "Configuration": configuration,
            "Description": description,
            "Schedule": schedule,
            "RoleArn": role_arn,
        },
    )
