"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def list_all(
    hub, ctx, cluster_arn: str, max_results: int = None, next_token: str = None
) -> Dict:
    r"""
        **Autogenerated function**


        Returns a list of the Scram Secrets associated with an Amazon MSK cluster.


        Args:
            cluster_arn(str):
    The arn of the cluster.
    .
            max_results(int, optional):
    The maxResults of the query.
    . Defaults to None.
            next_token(str, optional):
    The nextToken of the query.
    . Defaults to None.

        Returns:
            Dict

        Examples:
            Call from code:

            .. code-block:: python

                await hub.exec.aws_auto.kafka.scram_secret.list_all(ctx, cluster_arn=value)

            Call from CLI:

            .. code-block:: bash

                $ idem exec aws_auto.kafka.scram_secret.list_all cluster_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="kafka",
        operation="list_scram_secrets",
        op_kwargs={
            "ClusterArn": cluster_arn,
            "MaxResults": max_results,
            "NextToken": next_token,
        },
    )
