"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def tag(hub, ctx, resource_arn: str, tags: Dict) -> None:
    r"""
        **Autogenerated function**


        Adds tags to the specified MSK resource.


        Args:
            resource_arn(str):
    The Amazon Resource Name (ARN) that uniquely identifies the resource that's associated with the tags.
    .
            tags(Dict):
    The key-value pair for the resource tag.
    .
        Examples:
            Call from code:

            .. code-block:: python

                await hub.exec.aws_auto.kafka.resource.tag(ctx, resource_arn=value, tags=value)

            Call from CLI:

            .. code-block:: bash

                $ idem exec aws_auto.kafka.resource.tag resource_arn=value, tags=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="kafka",
        operation="tag_resource",
        op_kwargs={"ResourceArn": resource_arn, "Tags": tags},
    )


async def untag(hub, ctx, resource_arn: str, tag_keys: List) -> None:
    r"""
        **Autogenerated function**


        Removes the tags associated with the keys that are provided in the query.


        Args:
            resource_arn(str):
    The Amazon Resource Name (ARN) that uniquely identifies the resource that's associated with the tags.
    .
            tag_keys(List):
    Tag keys must be unique for a given cluster. In addition, the following restrictions apply:


    Each tag key must be unique. If you add a tag with a key that's already in
                      use, your new tag overwrites the existing key-value pair.


    You can't start a tag key with aws: because this prefix is reserved for use
                      by  AWS.  AWS creates tags that begin with this prefix on your behalf, but
                      you can't edit or delete them.


    Tag keys must be between 1 and 128 Unicode characters in length.


    Tag keys must consist of the following characters: Unicode letters, digits,
                      white space, and the following special characters: _ . / = + -
                         @.


    .
        Examples:
            Call from code:

            .. code-block:: python

                await hub.exec.aws_auto.kafka.resource.untag(ctx, resource_arn=value, tag_keys=value)

            Call from CLI:

            .. code-block:: bash

                $ idem exec aws_auto.kafka.resource.untag resource_arn=value, tag_keys=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="kafka",
        operation="untag_resource",
        op_kwargs={"ResourceArn": resource_arn, "TagKeys": tag_keys},
    )
