"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def update(
    hub,
    ctx,
    cluster_arn: str,
    current_version: str,
    enhanced_monitoring: str = None,
    open_monitoring: Dict = None,
    logging_info: Dict = None,
) -> Dict:
    r"""
        **Autogenerated function**


        Updates the monitoring settings for the cluster. You can use this operation to specify which Apache Kafka metrics you want Amazon MSK to send to Amazon CloudWatch. You can also specify settings for open monitoring with Prometheus.


        Args:
            cluster_arn(str):
    The Amazon Resource Name (ARN) that uniquely identifies the cluster.
    .
            current_version(str):
    The version of the MSK cluster to update. Cluster versions aren't simple numbers. You can describe an MSK cluster to find its version. When this update operation is successful, it generates a new cluster version.
    .
            enhanced_monitoring(str, optional):
    Specifies which Apache Kafka metrics Amazon MSK gathers and sends to Amazon CloudWatch for this cluster.
    . Defaults to None.
            open_monitoring(Dict, optional):
    The settings for open monitoring.
    . Defaults to None.
            logging_info(Dict, optional): . Defaults to None.

        Returns:
            Dict

        Examples:
            Call from code:

            .. code-block:: python

                await hub.exec.aws_auto.kafka.monitoring.update(
                    ctx, cluster_arn=value, current_version=value
                )

            Call from CLI:

            .. code-block:: bash

                $ idem exec aws_auto.kafka.monitoring.update cluster_arn=value, current_version=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="kafka",
        operation="update_monitoring",
        op_kwargs={
            "ClusterArn": cluster_arn,
            "CurrentVersion": current_version,
            "EnhancedMonitoring": enhanced_monitoring,
            "OpenMonitoring": open_monitoring,
            "LoggingInfo": logging_info,
        },
    )
