"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def list_all(hub, ctx, max_results: int = None, next_token: str = None) -> Dict:
    r"""
        **Autogenerated function**


        Returns a list of Kafka versions.


        Args:
            max_results(int, optional):
    The maximum number of results to return in the response. If there are more results, the response includes a NextToken parameter. Defaults to None.
            next_token(str, optional):
    The paginated results marker. When the result of the operation is truncated, the call returns NextToken in the response. To get the next batch, provide this token in your next request. Defaults to None.

        Returns:
            Dict

        Examples:
            Call from code:

            .. code-block:: python

                await hub.exec.aws_auto.kafka.kafka_version.list_all(ctx)

            Call from CLI:

            .. code-block:: bash

                $ idem exec aws_auto.kafka.kafka_version.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="kafka",
        operation="list_kafka_versions",
        op_kwargs={"MaxResults": max_results, "NextToken": next_token},
    )
