"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def describe(hub, ctx, arn: str, revision: int) -> Dict:
    r"""
        **Autogenerated function**


        Returns a description of this revision of the configuration.


        Args:
            arn(str):
    The Amazon Resource Name (ARN) that uniquely identifies an MSK configuration and all of its revisions.
    .
            revision(int):
    A string that uniquely identifies a revision of an MSK configuration.
    .

        Returns:
            Dict

        Examples:
            Call from code:

            .. code-block:: python

                await hub.exec.aws_auto.kafka.configuration.revision.describe(
                    ctx, arn=value, revision=value
                )

            Call from CLI:

            .. code-block:: bash

                $ idem exec aws_auto.kafka.configuration.revision.describe arn=value, revision=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="kafka",
        operation="describe_configuration_revision",
        op_kwargs={"Arn": arn, "Revision": revision},
    )


async def list_all(
    hub, ctx, arn: str, max_results: int = None, next_token: str = None
) -> Dict:
    r"""
        **Autogenerated function**


        Returns a list of all the MSK configurations in this Region.


        Args:
            arn(str):
    The Amazon Resource Name (ARN) that uniquely identifies an MSK configuration and all of its revisions.
    .
            max_results(int, optional):
    The maximum number of results to return in the response. If there are more results, the response includes a NextToken parameter.
    . Defaults to None.
            next_token(str, optional):
    The paginated results marker. When the result of the operation is truncated, the call returns NextToken in the response.
                To get the next batch, provide this token in your next request.
    . Defaults to None.

        Returns:
            Dict

        Examples:
            Call from code:

            .. code-block:: python

                await hub.exec.aws_auto.kafka.configuration.revision.list_all(ctx, arn=value)

            Call from CLI:

            .. code-block:: bash

                $ idem exec aws_auto.kafka.configuration.revision.list_all arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="kafka",
        operation="list_configuration_revisions",
        op_kwargs={"Arn": arn, "MaxResults": max_results, "NextToken": next_token},
    )
