"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    name: str,
    server_properties: bytes,
    description: str = None,
    kafka_versions: List = None,
) -> Dict:
    r"""
        **Autogenerated function**


        Creates a new MSK configuration.


        Args:
            description(str, optional):
    The description of the configuration.
    . Defaults to None.
            kafka_versions(List, optional):
    The versions of Apache Kafka with which you can use this MSK configuration.
    . Defaults to None.
            name(str):
    The name of the configuration.
    .
            server_properties(bytes):
    Contents of the server.properties file. When using the API, you must ensure that the contents of the file are base64 encoded.
                   When using the AWS Management Console, the SDK, or the AWS CLI, the contents of server.properties can be in plaintext.
    .

        Returns:
            Dict

        Examples:
            Call from code:

            .. code-block:: python

                await hub.exec.aws_auto.kafka.configuration.init.create(
                    ctx, name=value, server_properties=value
                )

            Call from CLI:

            .. code-block:: bash

                $ idem exec aws_auto.kafka.configuration.init.create name=value, server_properties=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="kafka",
        operation="create_configuration",
        op_kwargs={
            "Description": description,
            "KafkaVersions": kafka_versions,
            "Name": name,
            "ServerProperties": server_properties,
        },
    )


async def delete(hub, ctx, arn: str) -> Dict:
    r"""
        **Autogenerated function**


        Deletes an MSK Configuration.


        Args:
            arn(str):
    The Amazon Resource Name (ARN) that uniquely identifies an MSK configuration.
    .

        Returns:
            Dict

        Examples:
            Call from code:

            .. code-block:: python

                await hub.exec.aws_auto.kafka.configuration.init.delete(ctx, arn=value)

            Call from CLI:

            .. code-block:: bash

                $ idem exec aws_auto.kafka.configuration.init.delete arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="kafka",
        operation="delete_configuration",
        op_kwargs={"Arn": arn},
    )


async def describe(hub, ctx, arn: str) -> Dict:
    r"""
        **Autogenerated function**


        Returns a description of this MSK configuration.


        Args:
            arn(str):
    The Amazon Resource Name (ARN) that uniquely identifies an MSK configuration and all of its revisions.
    .

        Returns:
            Dict

        Examples:
            Call from code:

            .. code-block:: python

                await hub.exec.aws_auto.kafka.configuration.init.describe(ctx, arn=value)

            Call from CLI:

            .. code-block:: bash

                $ idem exec aws_auto.kafka.configuration.init.describe arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="kafka",
        operation="describe_configuration",
        op_kwargs={"Arn": arn},
    )


async def list_all(hub, ctx, max_results: int = None, next_token: str = None) -> Dict:
    r"""
        **Autogenerated function**


        Returns a list of all the MSK configurations in this Region.


        Args:
            max_results(int, optional):
    The maximum number of results to return in the response. If there are more results, the response includes a NextToken parameter.
    . Defaults to None.
            next_token(str, optional):
    The paginated results marker. When the result of the operation is truncated, the call returns NextToken in the response.
                To get the next batch, provide this token in your next request.
    . Defaults to None.

        Returns:
            Dict

        Examples:
            Call from code:

            .. code-block:: python

                await hub.exec.aws_auto.kafka.configuration.init.list_all(ctx)

            Call from CLI:

            .. code-block:: bash

                $ idem exec aws_auto.kafka.configuration.init.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="kafka",
        operation="list_configurations",
        op_kwargs={"MaxResults": max_results, "NextToken": next_token},
    )


async def update(
    hub, ctx, arn: str, server_properties: bytes, description: str = None
) -> Dict:
    r"""
        **Autogenerated function**


        Updates an MSK configuration.


        Args:
            arn(str):
    The Amazon Resource Name (ARN) of the configuration.
    .
            description(str, optional):
    The description of the configuration revision.
    . Defaults to None.
            server_properties(bytes):
    Contents of the server.properties file. When using the API, you must ensure that the contents of the file are base64 encoded.
                   When using the AWS Management Console, the SDK, or the AWS CLI, the contents of server.properties can be in plaintext.
    .

        Returns:
            Dict

        Examples:
            Call from code:

            .. code-block:: python

                await hub.exec.aws_auto.kafka.configuration.init.update(
                    ctx, arn=value, server_properties=value
                )

            Call from CLI:

            .. code-block:: bash

                $ idem exec aws_auto.kafka.configuration.init.update arn=value, server_properties=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="kafka",
        operation="update_configuration",
        op_kwargs={
            "Arn": arn,
            "Description": description,
            "ServerProperties": server_properties,
        },
    )
