"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get_all(hub, ctx, cluster_arn: str = None) -> Dict:
    r"""
        **Autogenerated function**


        Gets the Apache Kafka versions to which you can update the MSK cluster.


        Args:
            cluster_arn(str, optional):
    The Amazon Resource Name (ARN) of the cluster check.
    . Defaults to None.

        Returns:
            Dict

        Examples:
            Call from code:

            .. code-block:: python

                await hub.exec.aws_auto.kafka.compatible_kafka_version.get_all(ctx)

            Call from CLI:

            .. code-block:: bash

                $ idem exec aws_auto.kafka.compatible_kafka_version.get_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="kafka",
        operation="get_compatible_kafka_versions",
        op_kwargs={"ClusterArn": cluster_arn},
    )
