"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def describe(hub, ctx, cluster_operation_arn: str) -> Dict:
    r"""
        **Autogenerated function**


        Returns a description of the cluster operation specified by the ARN.


        Args:
            cluster_operation_arn(str):
    The Amazon Resource Name (ARN) that uniquely identifies the MSK cluster operation.
    .

        Returns:
            Dict

        Examples:
            Call from code:

            .. code-block:: python

                await hub.exec.aws_auto.kafka.cluster.operation.describe(
                    ctx, cluster_operation_arn=value
                )

            Call from CLI:

            .. code-block:: bash

                $ idem exec aws_auto.kafka.cluster.operation.describe cluster_operation_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="kafka",
        operation="describe_cluster_operation",
        op_kwargs={"ClusterOperationArn": cluster_operation_arn},
    )


async def list_all(
    hub, ctx, cluster_arn: str, max_results: int = None, next_token: str = None
) -> Dict:
    r"""
        **Autogenerated function**


        Returns a list of all the operations that have been performed on the specified MSK cluster.


        Args:
            cluster_arn(str):
    The Amazon Resource Name (ARN) that uniquely identifies the cluster.
    .
            max_results(int, optional):
    The maximum number of results to return in the response. If there are more results, the response includes a NextToken parameter.
    . Defaults to None.
            next_token(str, optional):
    The paginated results marker. When the result of the operation is truncated, the call returns NextToken in the response.
                To get the next batch, provide this token in your next request.
    . Defaults to None.

        Returns:
            Dict

        Examples:
            Call from code:

            .. code-block:: python

                await hub.exec.aws_auto.kafka.cluster.operation.list_all(ctx, cluster_arn=value)

            Call from CLI:

            .. code-block:: bash

                $ idem exec aws_auto.kafka.cluster.operation.list_all cluster_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="kafka",
        operation="list_cluster_operations",
        op_kwargs={
            "ClusterArn": cluster_arn,
            "MaxResults": max_results,
            "NextToken": next_token,
        },
    )
