"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def update(
    hub,
    ctx,
    cluster_arn: str,
    current_version: str,
    target_kafka_version: str,
    configuration_info: Dict = None,
) -> Dict:
    r"""
        **Autogenerated function**


        Updates the Apache Kafka version for the cluster.


        Args:
            cluster_arn(str):
    The Amazon Resource Name (ARN) of the cluster to be updated.
    .
            configuration_info(Dict, optional):
    The custom configuration that should be applied on the new version of cluster.
    . Defaults to None.
            current_version(str):
    Current cluster version.
    .
            target_kafka_version(str):
    Target Kafka version.
    .

        Returns:
            Dict

        Examples:
            Call from code:

            .. code-block:: python

                await hub.exec.aws_auto.kafka.cluster.kafka_version.update(
                    ctx, cluster_arn=value, current_version=value, target_kafka_version=value
                )

            Call from CLI:

            .. code-block:: bash

                $ idem exec aws_auto.kafka.cluster.kafka_version.update cluster_arn=value, current_version=value, target_kafka_version=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="kafka",
        operation="update_cluster_kafka_version",
        op_kwargs={
            "ClusterArn": cluster_arn,
            "ConfigurationInfo": configuration_info,
            "CurrentVersion": current_version,
            "TargetKafkaVersion": target_kafka_version,
        },
    )
