"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(
    hub,
    ctx,
    broker_node_group_info: Dict,
    cluster_name: str,
    kafka_version: str,
    number_of_broker_nodes: int,
    client_authentication: Dict = None,
    configuration_info: Dict = None,
    encryption_info: Dict = None,
    enhanced_monitoring: str = None,
    open_monitoring: Dict = None,
    logging_info: Dict = None,
    tags: Dict = None,
) -> Dict:
    r"""
        **Autogenerated function**


        Creates a new MSK cluster.


        Args:
            broker_node_group_info(Dict):
    Information about the broker nodes in the cluster.
    .
            client_authentication(Dict, optional):
    Includes all client authentication related information.
    . Defaults to None.
            cluster_name(str):
    The name of the cluster.
    .
            configuration_info(Dict, optional):
    Represents the configuration that you want MSK to use for the brokers in a cluster.
    . Defaults to None.
            encryption_info(Dict, optional):
    Includes all encryption-related information.
    . Defaults to None.
            enhanced_monitoring(str, optional):
    Specifies the level of monitoring for the MSK cluster. The possible values are DEFAULT, PER_BROKER, PER_TOPIC_PER_BROKER, and PER_TOPIC_PER_PARTITION.
    . Defaults to None.
            open_monitoring(Dict, optional):
    The settings for open monitoring.
    . Defaults to None.
            kafka_version(str):
    The version of Apache Kafka.
    .
            logging_info(Dict, optional): . Defaults to None.
            number_of_broker_nodes(int):
    The number of broker nodes in the cluster.
    .
            tags(Dict, optional):
    Create tags when creating the cluster.
    . Defaults to None.

        Returns:
            Dict

        Examples:
            Call from code:

            .. code-block:: python

                await hub.exec.aws_auto.kafka.cluster.init.create(
                    ctx,
                    broker_node_group_info=value,
                    cluster_name=value,
                    kafka_version=value,
                    number_of_broker_nodes=value,
                )

            Call from CLI:

            .. code-block:: bash

                $ idem exec aws_auto.kafka.cluster.init.create broker_node_group_info=value, cluster_name=value, kafka_version=value, number_of_broker_nodes=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="kafka",
        operation="create_cluster",
        op_kwargs={
            "BrokerNodeGroupInfo": broker_node_group_info,
            "ClientAuthentication": client_authentication,
            "ClusterName": cluster_name,
            "ConfigurationInfo": configuration_info,
            "EncryptionInfo": encryption_info,
            "EnhancedMonitoring": enhanced_monitoring,
            "OpenMonitoring": open_monitoring,
            "KafkaVersion": kafka_version,
            "LoggingInfo": logging_info,
            "NumberOfBrokerNodes": number_of_broker_nodes,
            "Tags": tags,
        },
    )


async def delete(hub, ctx, cluster_arn: str, current_version: str = None) -> Dict:
    r"""
        **Autogenerated function**


        Deletes the MSK cluster specified by the Amazon Resource Name (ARN) in the request.


        Args:
            cluster_arn(str):
    The Amazon Resource Name (ARN) that uniquely identifies the cluster.
    .
            current_version(str, optional):
    The current version of the MSK cluster.
    . Defaults to None.

        Returns:
            Dict

        Examples:
            Call from code:

            .. code-block:: python

                await hub.exec.aws_auto.kafka.cluster.init.delete(ctx, cluster_arn=value)

            Call from CLI:

            .. code-block:: bash

                $ idem exec aws_auto.kafka.cluster.init.delete cluster_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="kafka",
        operation="delete_cluster",
        op_kwargs={"ClusterArn": cluster_arn, "CurrentVersion": current_version},
    )


async def describe(hub, ctx, cluster_arn: str) -> Dict:
    r"""
        **Autogenerated function**


        Returns a description of the MSK cluster whose Amazon Resource Name (ARN) is specified in the request.


        Args:
            cluster_arn(str):
    The Amazon Resource Name (ARN) that uniquely identifies the cluster.
    .

        Returns:
            Dict

        Examples:
            Call from code:

            .. code-block:: python

                await hub.exec.aws_auto.kafka.cluster.init.describe(ctx, cluster_arn=value)

            Call from CLI:

            .. code-block:: bash

                $ idem exec aws_auto.kafka.cluster.init.describe cluster_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="kafka",
        operation="describe_cluster",
        op_kwargs={"ClusterArn": cluster_arn},
    )


async def list_all(
    hub,
    ctx,
    cluster_name_filter: str = None,
    max_results: int = None,
    next_token: str = None,
) -> Dict:
    r"""
        **Autogenerated function**


        Returns a list of all the MSK clusters in the current Region.


        Args:
            cluster_name_filter(str, optional):
    Specify a prefix of the name of the clusters that you want to list. The service lists all the clusters whose names start with this prefix.
    . Defaults to None.
            max_results(int, optional):
    The maximum number of results to return in the response. If there are more results, the response includes a NextToken parameter.
    . Defaults to None.
            next_token(str, optional):
    The paginated results marker. When the result of the operation is truncated, the call returns NextToken in the response.
                To get the next batch, provide this token in your next request.
    . Defaults to None.

        Returns:
            Dict

        Examples:
            Call from code:

            .. code-block:: python

                await hub.exec.aws_auto.kafka.cluster.init.list_all(ctx)

            Call from CLI:

            .. code-block:: bash

                $ idem exec aws_auto.kafka.cluster.init.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="kafka",
        operation="list_clusters",
        op_kwargs={
            "ClusterNameFilter": cluster_name_filter,
            "MaxResults": max_results,
            "NextToken": next_token,
        },
    )
