"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def update(
    hub, ctx, cluster_arn: str, configuration_info: Dict, current_version: str
) -> Dict:
    r"""
        **Autogenerated function**


        Updates the cluster with the configuration that is specified in the request body.


        Args:
            cluster_arn(str):
    The Amazon Resource Name (ARN) that uniquely identifies the cluster.
    .
            configuration_info(Dict):
    Represents the configuration that you want MSK to use for the brokers in a cluster.
    .
            current_version(str):
    The version of the cluster that needs to be updated.
    .

        Returns:
            Dict

        Examples:
            Call from code:

            .. code-block:: python

                await hub.exec.aws_auto.kafka.cluster.configuration.update(
                    ctx, cluster_arn=value, configuration_info=value, current_version=value
                )

            Call from CLI:

            .. code-block:: bash

                $ idem exec aws_auto.kafka.cluster.configuration.update cluster_arn=value, configuration_info=value, current_version=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="kafka",
        operation="update_cluster_configuration",
        op_kwargs={
            "ClusterArn": cluster_arn,
            "ConfigurationInfo": configuration_info,
            "CurrentVersion": current_version,
        },
    )
