"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


__virtualname__ = "type"


async def update(
    hub, ctx, cluster_arn: str, current_version: str, target_instance_type: str
) -> Dict:
    r"""
        **Autogenerated function**


        Updates EC2 instance type.


        Args:
            cluster_arn(str):
    The Amazon Resource Name (ARN) that uniquely identifies the cluster.
    .
            current_version(str):
    The cluster version that you want to change. After this operation completes successfully, the cluster will have a new version.
    .
            target_instance_type(str):
    The Amazon MSK broker type that you want all of the brokers in this cluster to be.
    .

        Returns:
            Dict

        Examples:
            Call from code:

            .. code-block:: python

                await hub.exec.aws_auto.kafka.broker.type_.update(
                    ctx, cluster_arn=value, current_version=value, target_instance_type=value
                )

            Call from CLI:

            .. code-block:: bash

                $ idem exec aws_auto.kafka.broker.type.update cluster_arn=value, current_version=value, target_instance_type=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="kafka",
        operation="update_broker_type",
        op_kwargs={
            "ClusterArn": cluster_arn,
            "CurrentVersion": current_version,
            "TargetInstanceType": target_instance_type,
        },
    )
