"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def update(
    hub,
    ctx,
    cluster_arn: str,
    current_version: str,
    target_broker_ebs_volume_info: List,
) -> Dict:
    r"""
        **Autogenerated function**


        Updates the EBS storage associated with MSK brokers.


        Args:
            cluster_arn(str):
    The Amazon Resource Name (ARN) that uniquely identifies the cluster.
    .
            current_version(str):
    The version of cluster to update from. A successful operation will then generate a new version.
    .
            target_broker_ebs_volume_info(List):
    Describes the target volume size and the ID of the broker to apply the update to.
    .

        Returns:
            Dict

        Examples:
            Call from code:

            .. code-block:: python

                await hub.exec.aws_auto.kafka.broker.storage.update(
                    ctx, cluster_arn=value, current_version=value, target_broker_ebs_volume_info=value
                )

            Call from CLI:

            .. code-block:: bash

                $ idem exec aws_auto.kafka.broker.storage.update cluster_arn=value, current_version=value, target_broker_ebs_volume_info=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="kafka",
        operation="update_broker_storage",
        op_kwargs={
            "ClusterArn": cluster_arn,
            "CurrentVersion": current_version,
            "TargetBrokerEBSVolumeInfo": target_broker_ebs_volume_info,
        },
    )
