"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def reboot(hub, ctx, broker_ids: List, cluster_arn: str) -> Dict:
    r"""
        **Autogenerated function**

        Reboots brokers.

        Args:
            broker_ids(List):
    The list of broker IDs to be rebooted. The reboot-broker operation supports rebooting one broker at a time.
    .
            cluster_arn(str):
    The Amazon Resource Name (ARN) of the cluster to be updated.
    .

        Returns:
            Dict

        Examples:
            Call from code:

            .. code-block:: python

                await hub.exec.aws_auto.kafka.broker.init.reboot(
                    ctx, broker_ids=value, cluster_arn=value
                )

            Call from CLI:

            .. code-block:: bash

                $ idem exec aws_auto.kafka.broker.init.reboot broker_ids=value, cluster_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="kafka",
        operation="reboot_broker",
        op_kwargs={"BrokerIds": broker_ids, "ClusterArn": cluster_arn},
    )
