"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def update(
    hub, ctx, cluster_arn: str, current_version: str, target_number_of_broker_nodes: int
) -> Dict:
    r"""
        **Autogenerated function**


        Updates the number of broker nodes in the cluster.


        Args:
            cluster_arn(str):
    The Amazon Resource Name (ARN) that uniquely identifies the cluster.
    .
            current_version(str):
    The version of cluster to update from. A successful operation will then generate a new version.
    .
            target_number_of_broker_nodes(int):
    The number of broker nodes that you want the cluster to have after this operation completes successfully.
    .

        Returns:
            Dict

        Examples:
            Call from code:

            .. code-block:: python

                await hub.exec.aws_auto.kafka.broker.count.update(
                    ctx, cluster_arn=value, current_version=value, target_number_of_broker_nodes=value
                )

            Call from CLI:

            .. code-block:: bash

                $ idem exec aws_auto.kafka.broker.count.update cluster_arn=value, current_version=value, target_number_of_broker_nodes=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="kafka",
        operation="update_broker_count",
        op_kwargs={
            "ClusterArn": cluster_arn,
            "CurrentVersion": current_version,
            "TargetNumberOfBrokerNodes": target_number_of_broker_nodes,
        },
    )
