"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get_all(hub, ctx, cluster_arn: str) -> Dict:
    r"""
        **Autogenerated function**


        A list of brokers that a client application can use to bootstrap.


        Args:
            cluster_arn(str):
    The Amazon Resource Name (ARN) that uniquely identifies the cluster.
    .

        Returns:
            Dict

        Examples:
            Call from code:

            .. code-block:: python

                await hub.exec.aws_auto.kafka.bootstrap_broker.get_all(ctx, cluster_arn=value)

            Call from CLI:

            .. code-block:: bash

                $ idem exec aws_auto.kafka.bootstrap_broker.get_all cluster_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="kafka",
        operation="get_bootstrap_brokers",
        op_kwargs={"ClusterArn": cluster_arn},
    )
