"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


__func_alias__ = {"list_": "list"}


async def list_(
    hub, ctx, resource_arn: str, next_token: str = None, max_results: int = None
) -> Dict:
    r"""
    **Autogenerated function**

    Gets information about AWS tags for the specified ARN.

    Args:
        resource_arn(str): The ARN of the resource to be retrieved.
        next_token(str, optional): The first tag to retrieve. This is used for pagination; see the nextToken response field. Defaults to None.
        max_results(int, optional): Maximum number of tags to return. Default: 50. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ivs.tags_for_resource.list(ctx, resource_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ivs.tags_for_resource.list resource_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ivs",
        operation="list_tags_for_resource",
        op_kwargs={
            "resourceArn": resource_arn,
            "nextToken": next_token,
            "maxResults": max_results,
        },
    )
