"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(hub, ctx, channel_arn: str, tags: Dict = None) -> Dict:
    r"""
    **Autogenerated function**

    Creates a stream key, used to initiate a stream, for the specified channel ARN. Note that CreateChannel creates a stream key. If you subsequently use CreateStreamKey on the same channel, it will fail because a stream key already exists and there is a limit of 1 stream key per channel. To reset the stream key on a channel, use DeleteStreamKey and then CreateStreamKey.

    Args:
        channel_arn(str): ARN of the channel for which to create the stream key.
        tags(Dict, optional): Array of 1-50 maps, each of the form string:string (key:value). Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ivs.stream.key.create(ctx, channel_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ivs.stream.key.create channel_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ivs",
        operation="create_stream_key",
        op_kwargs={"channelArn": channel_arn, "tags": tags},
    )


async def delete(hub, ctx, arn: str) -> None:
    r"""
    **Autogenerated function**

    Deletes the stream key for the specified ARN, so it can no longer be used to stream.

    Args:
        arn(str): ARN of the stream key to be deleted.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ivs.stream.key.delete(ctx, arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ivs.stream.key.delete arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx, service_name="ivs", operation="delete_stream_key", op_kwargs={"arn": arn}
    )


async def get(hub, ctx, arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Gets stream-key information for a specified ARN.

    Args:
        arn(str): ARN for the stream key to be retrieved.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ivs.stream.key.get(ctx, arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ivs.stream.key.get arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx, service_name="ivs", operation="get_stream_key", op_kwargs={"arn": arn}
    )


async def list_all(
    hub, ctx, channel_arn: str, next_token: str = None, max_results: int = None
) -> Dict:
    r"""
    **Autogenerated function**

    Gets summary information about stream keys for the specified channel.

    Args:
        channel_arn(str): Channel ARN used to filter the list.
        next_token(str, optional): The first stream key to retrieve. This is used for pagination; see the nextToken response field. Defaults to None.
        max_results(int, optional): Maximum number of streamKeys to return. Default: 50. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ivs.stream.key.list_all(ctx, channel_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ivs.stream.key.list_all channel_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ivs",
        operation="list_stream_keys",
        op_kwargs={
            "channelArn": channel_arn,
            "nextToken": next_token,
            "maxResults": max_results,
        },
    )
