"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(hub, ctx, channel_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Gets information about the active (live) stream on a specified channel.

    Args:
        channel_arn(str): Channel ARN for stream to be accessed.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ivs.stream.init.get(ctx, channel_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ivs.stream.init.get channel_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ivs",
        operation="get_stream",
        op_kwargs={"channelArn": channel_arn},
    )


async def list_all(hub, ctx, next_token: str = None, max_results: int = None) -> Dict:
    r"""
    **Autogenerated function**

    Gets summary information about live streams in your account, in the AWS region where the API request is processed.

    Args:
        next_token(str, optional): The first stream to retrieve. This is used for pagination; see the nextToken response field. Defaults to None.
        max_results(int, optional): Maximum number of streams to return. Default: 50. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ivs.stream.init.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ivs.stream.init.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ivs",
        operation="list_streams",
        op_kwargs={"nextToken": next_token, "maxResults": max_results},
    )


async def stop(hub, ctx, channel_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Disconnects the incoming RTMPS stream for the specified channel. Can be used in conjunction with DeleteStreamKey to prevent further streaming to a channel.  Many streaming client-software libraries automatically reconnect a dropped RTMPS session, so to stop the stream permanently, you may want to first revoke the streamKey attached to the channel.

    Args:
        channel_arn(str): ARN of the channel for which the stream is to be stopped.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ivs.stream.init.stop(ctx, channel_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ivs.stream.init.stop channel_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ivs",
        operation="stop_stream",
        op_kwargs={"channelArn": channel_arn},
    )
