"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(
    hub, ctx, destination_configuration: Dict, name: str = None, tags: Dict = None
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a new recording configuration, used to enable recording to Amazon S3.  Known issue: In the us-east-1 region, if you use the AWS CLI to create a recording configuration, it returns success even if the S3 bucket is in a different region. In this case, the state of the recording configuration is CREATE_FAILED (instead of ACTIVE). (In other regions, the CLI correctly returns failure if the bucket is in a different region.)  Workaround: Ensure that your S3 bucket is in the same region as the recording configuration. If you create a recording configuration in a different region as your S3 bucket, delete that recording configuration and create a new one with an S3 bucket from the correct region.

    Args:
        name(str, optional): An arbitrary string (a nickname) that helps the customer identify that resource. The value does not need to be unique. Defaults to None.
        destination_configuration(Dict): A complex type that contains a destination configuration for where recorded video will be stored.
        tags(Dict, optional): Array of 1-50 maps, each of the form string:string (key:value). Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ivs.recording_configuration.create(
                ctx, destination_configuration=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ivs.recording_configuration.create destination_configuration=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ivs",
        operation="create_recording_configuration",
        op_kwargs={
            "name": name,
            "destinationConfiguration": destination_configuration,
            "tags": tags,
        },
    )


async def delete(hub, ctx, arn: str) -> None:
    r"""
    **Autogenerated function**

    Deletes the recording configuration for the specified ARN. If you try to delete a recording configuration that is associated with a channel, you will get an error (409 ConflictException). To avoid this, for all channels that reference the recording configuration, first use UpdateChannel to set the recordingConfigurationArn field to an empty string, then use DeleteRecordingConfiguration.

    Args:
        arn(str): ARN of the recording configuration to be deleted.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ivs.recording_configuration.delete(ctx, arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ivs.recording_configuration.delete arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ivs",
        operation="delete_recording_configuration",
        op_kwargs={"arn": arn},
    )


async def get(hub, ctx, arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Gets the recording configuration for the specified ARN.

    Args:
        arn(str): ARN of the recording configuration to be retrieved.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ivs.recording_configuration.get(ctx, arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ivs.recording_configuration.get arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ivs",
        operation="get_recording_configuration",
        op_kwargs={"arn": arn},
    )


async def list_all(hub, ctx, next_token: str = None, max_results: int = None) -> Dict:
    r"""
    **Autogenerated function**

    Gets summary information about all recording configurations in your account, in the AWS region where the API request is processed.

    Args:
        next_token(str, optional): The first recording configuration to retrieve. This is used for pagination; see the nextToken response field. Defaults to None.
        max_results(int, optional): Maximum number of recording configurations to return. Default: 50. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ivs.recording_configuration.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ivs.recording_configuration.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ivs",
        operation="list_recording_configurations",
        op_kwargs={"nextToken": next_token, "maxResults": max_results},
    )
