"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""


async def put(hub, ctx, channel_arn: str, metadata: str) -> None:
    r"""
    **Autogenerated function**

    Inserts metadata into the active stream of the specified channel. A maximum of 5 requests per second per channel is allowed, each with a maximum 1 KB payload. (If 5 TPS is not sufficient for your needs, we recommend batching your data into a single PutMetadata call.) Also see Embedding Metadata within a Video Stream in the Amazon IVS User Guide.

    Args:
        channel_arn(str): ARN of the channel into which metadata is inserted. This channel must have an active stream.
        metadata(str): Metadata to insert into the stream. Maximum: 1 KB per request.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ivs.metadata.put(ctx, channel_arn=value, metadata=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ivs.metadata.put channel_arn=value, metadata=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ivs",
        operation="put_metadata",
        op_kwargs={"channelArn": channel_arn, "metadata": metadata},
    )
