"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(
    hub,
    ctx,
    name: str = None,
    latency_mode: str = None,
    type_: str = None,
    authorized: bool = None,
    recording_configuration_arn: str = None,
    tags: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a new channel and an associated stream key to start streaming.

    Args:
        name(str, optional): Channel name. Defaults to None.
        latency_mode(str, optional): Channel latency mode. Use NORMAL to broadcast and deliver live video up to Full HD. Use LOW for near-real-time interaction with viewers. (Note: In the Amazon IVS console, LOW and NORMAL correspond to Ultra-low and Standard, respectively.) Default: LOW. Defaults to None.
        type_(str, optional): Channel type, which determines the allowable resolution and bitrate. If you exceed the allowable resolution or bitrate, the stream probably will disconnect immediately. Default: STANDARD. Valid values:    STANDARD: Multiple qualities are generated from the original input, to automatically give viewers the best experience for their devices and network conditions. Vertical resolution can be up to 1080 and bitrate can be up to 8.5 Mbps.    BASIC: Amazon IVS delivers the original input to viewers. The viewer’s video-quality choice is limited to the original input. Vertical resolution can be up to 480 and bitrate can be up to 1.5 Mbps.  . Defaults to None.
        authorized(bool, optional): Whether the channel is private (enabled for playback authorization). Default: false. Defaults to None.
        recording_configuration_arn(str, optional): Recording-configuration ARN. Default: "" (empty string, recording is disabled). Defaults to None.
        tags(Dict, optional): Array of 1-50 maps, each of the form string:string (key:value). Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ivs.channel.create(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ivs.channel.create
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ivs",
        operation="create_channel",
        op_kwargs={
            "name": name,
            "latencyMode": latency_mode,
            "type": type_,
            "authorized": authorized,
            "recordingConfigurationArn": recording_configuration_arn,
            "tags": tags,
        },
    )


async def delete(hub, ctx, arn: str) -> None:
    r"""
    **Autogenerated function**

    Deletes the specified channel and its associated stream keys. If you try to delete a live channel, you will get an error (409 ConflictException). To delete a channel that is live, call StopStream, wait for the Amazon EventBridge "Stream End" event (to verify that the stream's state was changed from Live to Offline), then call DeleteChannel. (See  Using EventBridge with Amazon IVS.)

    Args:
        arn(str): ARN of the channel to be deleted.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ivs.channel.delete(ctx, arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ivs.channel.delete arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx, service_name="ivs", operation="delete_channel", op_kwargs={"arn": arn}
    )


async def get(hub, ctx, arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Gets the channel configuration for the specified channel ARN. See also BatchGetChannel.

    Args:
        arn(str): ARN of the channel for which the configuration is to be retrieved.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ivs.channel.get(ctx, arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ivs.channel.get arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx, service_name="ivs", operation="get_channel", op_kwargs={"arn": arn}
    )


async def list_all(
    hub,
    ctx,
    filter_by_name: str = None,
    filter_by_recording_configuration_arn: str = None,
    next_token: str = None,
    max_results: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Gets summary information about all channels in your account, in the AWS region where the API request is processed. This list can be filtered to match a specified name or recording-configuration ARN. Filters are mutually exclusive and cannot be used together. If you try to use both filters, you will get an error (409 ConflictException).

    Args:
        filter_by_name(str, optional): Filters the channel list to match the specified name. Defaults to None.
        filter_by_recording_configuration_arn(str, optional): Filters the channel list to match the specified recording-configuration ARN. Defaults to None.
        next_token(str, optional): The first channel to retrieve. This is used for pagination; see the nextToken response field. Defaults to None.
        max_results(int, optional): Maximum number of channels to return. Default: 50. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ivs.channel.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ivs.channel.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ivs",
        operation="list_channels",
        op_kwargs={
            "filterByName": filter_by_name,
            "filterByRecordingConfigurationArn": filter_by_recording_configuration_arn,
            "nextToken": next_token,
            "maxResults": max_results,
        },
    )


async def update(
    hub,
    ctx,
    arn: str,
    name: str = None,
    latency_mode: str = None,
    type_: str = None,
    authorized: bool = None,
    recording_configuration_arn: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates a channel's configuration. This does not affect an ongoing stream of this channel. You must stop and restart the stream for the changes to take effect.

    Args:
        arn(str): ARN of the channel to be updated.
        name(str, optional): Channel name. Defaults to None.
        latency_mode(str, optional): Channel latency mode. Use NORMAL to broadcast and deliver live video up to Full HD. Use LOW for near-real-time interaction with viewers. (Note: In the Amazon IVS console, LOW and NORMAL correspond to Ultra-low and Standard, respectively.). Defaults to None.
        type_(str, optional): Channel type, which determines the allowable resolution and bitrate. If you exceed the allowable resolution or bitrate, the stream probably will disconnect immediately. Valid values:    STANDARD: Multiple qualities are generated from the original input, to automatically give viewers the best experience for their devices and network conditions. Vertical resolution can be up to 1080 and bitrate can be up to 8.5 Mbps.    BASIC: Amazon IVS delivers the original input to viewers. The viewer’s video-quality choice is limited to the original input. Vertical resolution can be up to 480 and bitrate can be up to 1.5 Mbps.  . Defaults to None.
        authorized(bool, optional): Whether the channel is private (enabled for playback authorization). Defaults to None.
        recording_configuration_arn(str, optional): Recording-configuration ARN. If this is set to an empty string, recording is disabled. A value other than an empty string indicates that recording is enabled. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ivs.channel.update(ctx, arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ivs.channel.update arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ivs",
        operation="update_channel",
        op_kwargs={
            "arn": arn,
            "name": name,
            "latencyMode": latency_mode,
            "type": type_,
            "authorized": authorized,
            "recordingConfigurationArn": recording_configuration_arn,
        },
    )
