"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(hub, ctx, id_: str, wireless_gateway_task_definition_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Creates a task for a wireless gateway.

    Args:
        id_(str): The ID of the resource to update.
        wireless_gateway_task_definition_id(str): The ID of the WirelessGatewayTaskDefinition.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iotwireless.wireless.gateway.task.init.create(
                ctx, id_=value, wireless_gateway_task_definition_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iotwireless.wireless.gateway.task.init.create id_=value, wireless_gateway_task_definition_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iotwireless",
        operation="create_wireless_gateway_task",
        op_kwargs={
            "Id": id_,
            "WirelessGatewayTaskDefinitionId": wireless_gateway_task_definition_id,
        },
    )


async def delete(hub, ctx, id_: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes a wireless gateway task.

    Args:
        id_(str): The ID of the resource to delete.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iotwireless.wireless.gateway.task.init.delete(ctx, id_=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iotwireless.wireless.gateway.task.init.delete id_=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iotwireless",
        operation="delete_wireless_gateway_task",
        op_kwargs={"Id": id_},
    )


async def get(hub, ctx, id_: str) -> Dict:
    r"""
    **Autogenerated function**

    Gets information about a wireless gateway task.

    Args:
        id_(str): The ID of the resource to get.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iotwireless.wireless.gateway.task.init.get(ctx, id_=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iotwireless.wireless.gateway.task.init.get id_=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iotwireless",
        operation="get_wireless_gateway_task",
        op_kwargs={"Id": id_},
    )
