"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    auto_create_tasks: bool,
    name: str = None,
    update: Dict = None,
    client_request_token: str = None,
    tags: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a gateway task definition.

    Args:
        auto_create_tasks(bool): Whether to automatically create tasks using this task definition for all gateways with the specified current version. If false, the task must me created by calling CreateWirelessGatewayTask.
        name(str, optional): The name of the new resource. Defaults to None.
        update(Dict, optional): Information about the gateways to update. Defaults to None.
        client_request_token(str, optional): Each resource must have a unique client request token. If you try to create a new resource with the same token as a resource that already exists, an exception occurs. If you omit this value, AWS SDKs will automatically generate a unique client request. . Defaults to None.
        tags(List, optional): The tags to attach to the specified resource. Tags are metadata that you can use to manage a resource. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iotwireless.wireless.gateway.task.definition.create(
                ctx, auto_create_tasks=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iotwireless.wireless.gateway.task.definition.create auto_create_tasks=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iotwireless",
        operation="create_wireless_gateway_task_definition",
        op_kwargs={
            "AutoCreateTasks": auto_create_tasks,
            "Name": name,
            "Update": update,
            "ClientRequestToken": client_request_token,
            "Tags": tags,
        },
    )


async def delete(hub, ctx, id_: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes a wireless gateway task definition. Deleting this task definition does not affect tasks that are currently in progress.

    Args:
        id_(str): The ID of the resource to delete.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iotwireless.wireless.gateway.task.definition.delete(
                ctx, id_=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iotwireless.wireless.gateway.task.definition.delete id_=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iotwireless",
        operation="delete_wireless_gateway_task_definition",
        op_kwargs={"Id": id_},
    )


async def get(hub, ctx, id_: str) -> Dict:
    r"""
    **Autogenerated function**

    Gets information about a wireless gateway task definition.

    Args:
        id_(str): The ID of the resource to get.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iotwireless.wireless.gateway.task.definition.get(ctx, id_=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iotwireless.wireless.gateway.task.definition.get id_=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iotwireless",
        operation="get_wireless_gateway_task_definition",
        op_kwargs={"Id": id_},
    )


async def list_all(
    hub,
    ctx,
    max_results: int = None,
    next_token: str = None,
    task_definition_type: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    List the wireless gateway tasks definitions registered to your AWS account.

    Args:
        max_results(int, optional): The maximum number of results to return in this operation. Defaults to None.
        next_token(str, optional): To retrieve the next set of results, the nextToken value from a previous response; otherwise null to receive the first set of results. Defaults to None.
        task_definition_type(str, optional): A filter to list only the wireless gateway task definitions that use this task definition type. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iotwireless.wireless.gateway.task.definition.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iotwireless.wireless.gateway.task.definition.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iotwireless",
        operation="list_wireless_gateway_task_definitions",
        op_kwargs={
            "MaxResults": max_results,
            "NextToken": next_token,
            "TaskDefinitionType": task_definition_type,
        },
    )
