"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get_all(hub, ctx, wireless_gateway_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Gets operating information about a wireless gateway.

    Args:
        wireless_gateway_id(str): The ID of the wireless gateway for which to get the data.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iotwireless.wireless.gateway.statistic.get_all(
                ctx, wireless_gateway_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iotwireless.wireless.gateway.statistic.get_all wireless_gateway_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iotwireless",
        operation="get_wireless_gateway_statistics",
        op_kwargs={"WirelessGatewayId": wireless_gateway_id},
    )
