"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    lo_ra_wan: Dict,
    name: str = None,
    description: str = None,
    tags: List = None,
    client_request_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Provisions a wireless gateway.

    Args:
        name(str, optional): The name of the new resource. Defaults to None.
        description(str, optional): The description of the new resource. Defaults to None.
        lo_ra_wan(Dict): The gateway configuration information to use to create the wireless gateway.
        tags(List, optional): The tags to attach to the new wireless gateway. Tags are metadata that you can use to manage a resource. Defaults to None.
        client_request_token(str, optional): Each resource must have a unique client request token. If you try to create a new resource with the same token as a resource that already exists, an exception occurs. If you omit this value, AWS SDKs will automatically generate a unique client request. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iotwireless.wireless.gateway.init.create(ctx, lo_ra_wan=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iotwireless.wireless.gateway.init.create lo_ra_wan=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iotwireless",
        operation="create_wireless_gateway",
        op_kwargs={
            "Name": name,
            "Description": description,
            "LoRaWAN": lo_ra_wan,
            "Tags": tags,
            "ClientRequestToken": client_request_token,
        },
    )


async def delete(hub, ctx, id_: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes a wireless gateway.

    Args:
        id_(str): The ID of the resource to delete.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iotwireless.wireless.gateway.init.delete(ctx, id_=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iotwireless.wireless.gateway.init.delete id_=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iotwireless",
        operation="delete_wireless_gateway",
        op_kwargs={"Id": id_},
    )


async def get(hub, ctx, identifier: str, identifier_type: str) -> Dict:
    r"""
    **Autogenerated function**

    Gets information about a wireless gateway.

    Args:
        identifier(str): The identifier of the wireless gateway to get.
        identifier_type(str): The type of identifier used in identifier.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iotwireless.wireless.gateway.init.get(
                ctx, identifier=value, identifier_type=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iotwireless.wireless.gateway.init.get identifier=value, identifier_type=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iotwireless",
        operation="get_wireless_gateway",
        op_kwargs={"Identifier": identifier, "IdentifierType": identifier_type},
    )


async def list_all(hub, ctx, next_token: str = None, max_results: int = None) -> Dict:
    r"""
    **Autogenerated function**

    Lists the wireless gateways registered to your AWS account.

    Args:
        next_token(str, optional): To retrieve the next set of results, the nextToken value from a previous response; otherwise null to receive the first set of results. Defaults to None.
        max_results(int, optional): The maximum number of results to return in this operation. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iotwireless.wireless.gateway.init.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iotwireless.wireless.gateway.init.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iotwireless",
        operation="list_wireless_gateways",
        op_kwargs={"NextToken": next_token, "MaxResults": max_results},
    )


async def update(
    hub,
    ctx,
    id_: str,
    name: str = None,
    description: str = None,
    join_eui_filters: List = None,
    net_id_filters: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates properties of a wireless gateway.

    Args:
        id_(str): The ID of the resource to update.
        name(str, optional): The new name of the resource. Defaults to None.
        description(str, optional): A new description of the resource. Defaults to None.
        join_eui_filters(List, optional): A list of JoinEuiRange used by LoRa gateways to filter LoRa frames. Defaults to None.
        net_id_filters(List, optional): A list of NetId values that are used by LoRa gateways to filter the uplink frames. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iotwireless.wireless.gateway.init.update(ctx, id_=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iotwireless.wireless.gateway.init.update id_=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iotwireless",
        operation="update_wireless_gateway",
        op_kwargs={
            "Id": id_,
            "Name": name,
            "Description": description,
            "JoinEuiFilters": join_eui_filters,
            "NetIdFilters": net_id_filters,
        },
    )
