"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def disassociate(hub, ctx, id_: str) -> Dict:
    r"""
    **Autogenerated function**

    Disassociates a wireless gateway from its currently associated certificate.

    Args:
        id_(str): The ID of the resource to update.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iotwireless.wireless.gateway.from_.certificate.disassociate(
                ctx, id_=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iotwireless.wireless.gateway.from_.certificate.disassociate id_=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iotwireless",
        operation="disassociate_wireless_gateway_from_certificate",
        op_kwargs={"Id": id_},
    )
