"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get_all(hub, ctx, id_: str) -> Dict:
    r"""
    **Autogenerated function**

    Gets the firmware version and other information about a wireless gateway.

    Args:
        id_(str): The ID of the resource to get.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iotwireless.wireless.gateway.firmware_information.get_all(
                ctx, id_=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iotwireless.wireless.gateway.firmware_information.get_all id_=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iotwireless",
        operation="get_wireless_gateway_firmware_information",
        op_kwargs={"Id": id_},
    )
