"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(hub, ctx, id_: str) -> Dict:
    r"""
    **Autogenerated function**

    Gets the ID of the certificate that is currently associated with a wireless gateway.

    Args:
        id_(str): The ID of the resource to get.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iotwireless.wireless.gateway.certificate.get(ctx, id_=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iotwireless.wireless.gateway.certificate.get id_=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iotwireless",
        operation="get_wireless_gateway_certificate",
        op_kwargs={"Id": id_},
    )
