"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    type_: str,
    destination_name: str,
    name: str = None,
    description: str = None,
    client_request_token: str = None,
    lo_ra_wan: Dict = None,
    tags: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Provisions a wireless device.

    Args:
        type_(str): The wireless device type.
        name(str, optional): The name of the new resource. Defaults to None.
        description(str, optional): The description of the new resource. Defaults to None.
        destination_name(str): The name of the destination to assign to the new wireless device.
        client_request_token(str, optional): Each resource must have a unique client request token. If you try to create a new resource with the same token as a resource that already exists, an exception occurs. If you omit this value, AWS SDKs will automatically generate a unique client request. . Defaults to None.
        lo_ra_wan(Dict, optional): The device configuration information to use to create the wireless device. Defaults to None.
        tags(List, optional): The tags to attach to the new wireless device. Tags are metadata that you can use to manage a resource. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iotwireless.wireless.device.init.create(
                ctx, type_=value, destination_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iotwireless.wireless.device.init.create type_=value, destination_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iotwireless",
        operation="create_wireless_device",
        op_kwargs={
            "Type": type_,
            "Name": name,
            "Description": description,
            "DestinationName": destination_name,
            "ClientRequestToken": client_request_token,
            "LoRaWAN": lo_ra_wan,
            "Tags": tags,
        },
    )


async def delete(hub, ctx, id_: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes a wireless device.

    Args:
        id_(str): The ID of the resource to delete.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iotwireless.wireless.device.init.delete(ctx, id_=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iotwireless.wireless.device.init.delete id_=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iotwireless",
        operation="delete_wireless_device",
        op_kwargs={"Id": id_},
    )


async def get(hub, ctx, identifier: str, identifier_type: str) -> Dict:
    r"""
    **Autogenerated function**

    Gets information about a wireless device.

    Args:
        identifier(str): The identifier of the wireless device to get.
        identifier_type(str): The type of identifier used in identifier.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iotwireless.wireless.device.init.get(
                ctx, identifier=value, identifier_type=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iotwireless.wireless.device.init.get identifier=value, identifier_type=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iotwireless",
        operation="get_wireless_device",
        op_kwargs={"Identifier": identifier, "IdentifierType": identifier_type},
    )


async def list_all(
    hub,
    ctx,
    max_results: int = None,
    next_token: str = None,
    destination_name: str = None,
    device_profile_id: str = None,
    service_profile_id: str = None,
    wireless_device_type: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Lists the wireless devices registered to your AWS account.

    Args:
        max_results(int, optional): The maximum number of results to return in this operation. Defaults to None.
        next_token(str, optional): To retrieve the next set of results, the nextToken value from a previous response; otherwise null to receive the first set of results. Defaults to None.
        destination_name(str, optional): A filter to list only the wireless devices that use this destination. Defaults to None.
        device_profile_id(str, optional): A filter to list only the wireless devices that use this device profile. Defaults to None.
        service_profile_id(str, optional): A filter to list only the wireless devices that use this service profile. Defaults to None.
        wireless_device_type(str, optional): A filter to list only the wireless devices that use this wireless device type. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iotwireless.wireless.device.init.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iotwireless.wireless.device.init.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iotwireless",
        operation="list_wireless_devices",
        op_kwargs={
            "MaxResults": max_results,
            "NextToken": next_token,
            "DestinationName": destination_name,
            "DeviceProfileId": device_profile_id,
            "ServiceProfileId": service_profile_id,
            "WirelessDeviceType": wireless_device_type,
        },
    )


async def test(hub, ctx, id_: str) -> Dict:
    r"""
    **Autogenerated function**

    Simulates a provisioned device by sending an uplink data payload of Hello.

    Args:
        id_(str): The ID of the wireless device to test.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iotwireless.wireless.device.init.test(ctx, id_=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iotwireless.wireless.device.init.test id_=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iotwireless",
        operation="test_wireless_device",
        op_kwargs={"Id": id_},
    )


async def update(
    hub,
    ctx,
    id_: str,
    destination_name: str = None,
    name: str = None,
    description: str = None,
    lo_ra_wan: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates properties of a wireless device.

    Args:
        id_(str): The ID of the resource to update.
        destination_name(str, optional): The name of the new destination for the device. Defaults to None.
        name(str, optional): The new name of the resource. Defaults to None.
        description(str, optional): A new description of the resource. Defaults to None.
        lo_ra_wan(Dict, optional): The updated wireless device's configuration. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iotwireless.wireless.device.init.update(ctx, id_=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iotwireless.wireless.device.init.update id_=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iotwireless",
        operation="update_wireless_device",
        op_kwargs={
            "Id": id_,
            "DestinationName": destination_name,
            "Name": name,
            "Description": description,
            "LoRaWAN": lo_ra_wan,
        },
    )
