"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    name: str = None,
    lo_ra_wan: Dict = None,
    tags: List = None,
    client_request_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a new service profile.

    Args:
        name(str, optional): The name of the new resource. Defaults to None.
        lo_ra_wan(Dict, optional): The service profile information to use to create the service profile. Defaults to None.
        tags(List, optional): The tags to attach to the new service profile. Tags are metadata that you can use to manage a resource. Defaults to None.
        client_request_token(str, optional): Each resource must have a unique client request token. If you try to create a new resource with the same token as a resource that already exists, an exception occurs. If you omit this value, AWS SDKs will automatically generate a unique client request. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iotwireless.service.profile.create(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iotwireless.service.profile.create
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iotwireless",
        operation="create_service_profile",
        op_kwargs={
            "Name": name,
            "LoRaWAN": lo_ra_wan,
            "Tags": tags,
            "ClientRequestToken": client_request_token,
        },
    )


async def delete(hub, ctx, id_: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes a service profile.

    Args:
        id_(str): The ID of the resource to delete.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iotwireless.service.profile.delete(ctx, id_=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iotwireless.service.profile.delete id_=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iotwireless",
        operation="delete_service_profile",
        op_kwargs={"Id": id_},
    )


async def get(hub, ctx, id_: str) -> Dict:
    r"""
    **Autogenerated function**

    Gets information about a service profile.

    Args:
        id_(str): The ID of the resource to get.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iotwireless.service.profile.get(ctx, id_=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iotwireless.service.profile.get id_=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iotwireless",
        operation="get_service_profile",
        op_kwargs={"Id": id_},
    )


async def list_all(hub, ctx, next_token: str = None, max_results: int = None) -> Dict:
    r"""
    **Autogenerated function**

    Lists the service profiles registered to your AWS account.

    Args:
        next_token(str, optional): To retrieve the next set of results, the nextToken value from a previous response; otherwise null to receive the first set of results. Defaults to None.
        max_results(int, optional): The maximum number of results to return in this operation. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iotwireless.service.profile.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iotwireless.service.profile.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iotwireless",
        operation="list_service_profiles",
        op_kwargs={"NextToken": next_token, "MaxResults": max_results},
    )
