"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(hub, ctx, partner_account_id: str, partner_type: str) -> Dict:
    r"""
    **Autogenerated function**

    Gets information about a partner account. If PartnerAccountId and PartnerType are null, returns all partner accounts.

    Args:
        partner_account_id(str): The partner account ID to disassociate from the AWS account.
        partner_type(str): The partner type.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iotwireless.partner_account.get(
                ctx, partner_account_id=value, partner_type=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iotwireless.partner_account.get partner_account_id=value, partner_type=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iotwireless",
        operation="get_partner_account",
        op_kwargs={"PartnerAccountId": partner_account_id, "PartnerType": partner_type},
    )


async def list_all(hub, ctx, next_token: str = None, max_results: int = None) -> Dict:
    r"""
    **Autogenerated function**

    Lists the partner accounts associated with your AWS account.

    Args:
        next_token(str, optional): To retrieve the next set of results, the nextToken value from a previous response; otherwise null to receive the first set of results. Defaults to None.
        max_results(int, optional): The maximum number of results to return in this operation. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iotwireless.partner_account.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iotwireless.partner_account.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iotwireless",
        operation="list_partner_accounts",
        op_kwargs={"NextToken": next_token, "MaxResults": max_results},
    )


async def update(
    hub, ctx, sidewalk: Dict, partner_account_id: str, partner_type: str
) -> Dict:
    r"""
    **Autogenerated function**

    Updates properties of a partner account.

    Args:
        sidewalk(Dict): The Sidewalk account credentials.
        partner_account_id(str): The ID of the partner account to update.
        partner_type(str): The partner type.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iotwireless.partner_account.update(
                ctx, sidewalk=value, partner_account_id=value, partner_type=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iotwireless.partner_account.update sidewalk=value, partner_account_id=value, partner_type=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iotwireless",
        operation="update_partner_account",
        op_kwargs={
            "Sidewalk": sidewalk,
            "PartnerAccountId": partner_account_id,
            "PartnerType": partner_type,
        },
    )
