"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


__virtualname__ = "log_level_by_resource_type"


async def get_all(hub, ctx) -> Dict:
    r"""
    **Autogenerated function**

    Returns current default log levels or log levels by resource types. Based on resource types, log levels can be for wireless device log options or wireless gateway log options.


    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iotwireless.log_level_by_resource_type_.get_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iotwireless.log_level_by_resource_type.get_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iotwireless",
        operation="get_log_levels_by_resource_types",
        op_kwargs={},
    )


async def update_multiple(
    hub,
    ctx,
    default_log_level: str = None,
    wireless_device_log_options: List = None,
    wireless_gateway_log_options: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Set default log level, or log levels by resource types. This can be for wireless device log options or wireless gateways log options and is used to control the log messages that'll be displayed in CloudWatch.

    Args:
        default_log_level(str, optional): The log level for a log message. Defaults to None.
        wireless_device_log_options(List, optional): The list of wireless device log options. Defaults to None.
        wireless_gateway_log_options(List, optional): The list of wireless gateway log options. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iotwireless.log_level_by_resource_type_.update_multiple(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iotwireless.log_level_by_resource_type.update_multiple
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iotwireless",
        operation="update_log_levels_by_resource_types",
        op_kwargs={
            "DefaultLogLevel": default_log_level,
            "WirelessDeviceLogOptions": wireless_device_log_options,
            "WirelessGatewayLogOptions": wireless_gateway_log_options,
        },
    )
