"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    name: str,
    expression_type: str,
    expression: str,
    role_arn: str,
    description: str = None,
    tags: List = None,
    client_request_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a new destination that maps a device message to an AWS IoT rule.

    Args:
        name(str): The name of the new resource.
        expression_type(str): The type of value in Expression.
        expression(str): The rule name or topic rule to send messages to.
        description(str, optional): The description of the new resource. Defaults to None.
        role_arn(str): The ARN of the IAM Role that authorizes the destination.
        tags(List, optional): The tags to attach to the new destination. Tags are metadata that you can use to manage a resource. Defaults to None.
        client_request_token(str, optional): Each resource must have a unique client request token. If you try to create a new resource with the same token as a resource that already exists, an exception occurs. If you omit this value, AWS SDKs will automatically generate a unique client request. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iotwireless.destination.create(
                ctx, name=value, expression_type=value, expression=value, role_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iotwireless.destination.create name=value, expression_type=value, expression=value, role_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iotwireless",
        operation="create_destination",
        op_kwargs={
            "Name": name,
            "ExpressionType": expression_type,
            "Expression": expression,
            "Description": description,
            "RoleArn": role_arn,
            "Tags": tags,
            "ClientRequestToken": client_request_token,
        },
    )


async def delete(hub, ctx, name: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes a destination.

    Args:
        name(str): The name of the resource to delete.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iotwireless.destination.delete(ctx, name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iotwireless.destination.delete name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iotwireless",
        operation="delete_destination",
        op_kwargs={"Name": name},
    )


async def get(hub, ctx, name: str) -> Dict:
    r"""
    **Autogenerated function**

    Gets information about a destination.

    Args:
        name(str): The name of the resource to get.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iotwireless.destination.get(ctx, name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iotwireless.destination.get name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iotwireless",
        operation="get_destination",
        op_kwargs={"Name": name},
    )


async def list_all(hub, ctx, max_results: int = None, next_token: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Lists the destinations registered to your AWS account.

    Args:
        max_results(int, optional): The maximum number of results to return in this operation. Defaults to None.
        next_token(str, optional): To retrieve the next set of results, the nextToken value from a previous response; otherwise null to receive the first set of results. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iotwireless.destination.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iotwireless.destination.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iotwireless",
        operation="list_destinations",
        op_kwargs={"MaxResults": max_results, "NextToken": next_token},
    )


async def update(
    hub,
    ctx,
    name: str,
    expression_type: str = None,
    expression: str = None,
    description: str = None,
    role_arn: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates properties of a destination.

    Args:
        name(str): The new name of the resource.
        expression_type(str, optional): The type of value in Expression. Defaults to None.
        expression(str, optional): The new rule name or topic rule to send messages to. Defaults to None.
        description(str, optional): A new description of the resource. Defaults to None.
        role_arn(str, optional): The ARN of the IAM Role that authorizes the destination. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iotwireless.destination.update(ctx, name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iotwireless.destination.update name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iotwireless",
        operation="update_destination",
        op_kwargs={
            "Name": name,
            "ExpressionType": expression_type,
            "Expression": expression,
            "Description": description,
            "RoleArn": role_arn,
        },
    )
