"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def send(
    hub,
    ctx,
    id_: str,
    transmit_mode: int,
    payload_data: str,
    wireless_metadata: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Sends a decrypted application data frame to a device.

    Args:
        id_(str): The ID of the wireless device to receive the data.
        transmit_mode(int): The transmit mode to use to send data to the wireless device. Can be: 0 for UM (unacknowledge mode) or 1 for AM (acknowledge mode).
        payload_data(str): The binary to be sent to the end device, encoded in base64.
        wireless_metadata(Dict, optional): Metadata about the message request. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iotwireless.data_to_wireless_device.send(
                ctx, id_=value, transmit_mode=value, payload_data=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iotwireless.data_to_wireless_device.send id_=value, transmit_mode=value, payload_data=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iotwireless",
        operation="send_data_to_wireless_device",
        op_kwargs={
            "Id": id_,
            "TransmitMode": transmit_mode,
            "PayloadData": payload_data,
            "WirelessMetadata": wireless_metadata,
        },
    )
