"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def associate(
    hub, ctx, sidewalk: Dict, client_request_token: str = None, tags: List = None
) -> Dict:
    r"""
    **Autogenerated function**

    Associates a partner account with your AWS account.

    Args:
        sidewalk(Dict): The Sidewalk account credentials.
        client_request_token(str, optional): Each resource must have a unique client request token. If you try to create a new resource with the same token as a resource that already exists, an exception occurs. If you omit this value, AWS SDKs will automatically generate a unique client request. . Defaults to None.
        tags(List, optional): The tags to attach to the specified resource. Tags are metadata that you can use to manage a resource. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iotwireless.aws_account.with_partner_account.associate(
                ctx, sidewalk=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iotwireless.aws_account.with_partner_account.associate sidewalk=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iotwireless",
        operation="associate_aws_account_with_partner_account",
        op_kwargs={
            "Sidewalk": sidewalk,
            "ClientRequestToken": client_request_token,
            "Tags": tags,
        },
    )
