"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def disassociate(hub, ctx, partner_account_id: str, partner_type: str) -> Dict:
    r"""
    **Autogenerated function**

    Disassociates your AWS account from a partner account. If PartnerAccountId and PartnerType are null, disassociates your AWS account from all partner accounts.

    Args:
        partner_account_id(str): The partner account ID to disassociate from the AWS account.
        partner_type(str): The partner type.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iotwireless.aws_account.from_partner_account.disassociate(
                ctx, partner_account_id=value, partner_type=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iotwireless.aws_account.from_partner_account.disassociate partner_account_id=value, partner_type=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iotwireless",
        operation="disassociate_aws_account_from_partner_account",
        op_kwargs={"PartnerAccountId": partner_account_id, "PartnerType": partner_type},
    )
