"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def reset(hub, ctx) -> Dict:
    r"""
    **Autogenerated function**

    Removes the log-level overrides for all resources; both wireless devices and wireless gateways.


    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iotwireless.all_resource_log_level.reset(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iotwireless.all_resource_log_level.reset
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iotwireless",
        operation="reset_all_resource_log_levels",
        op_kwargs={},
    )
