"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(hub, ctx, upload_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Gets the status of the specified upload.

    Args:
        upload_id(str): The ID of the upload. This value is returned by the UploadEntityDefinitions action.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iotthingsgraph.upload_status.get(ctx, upload_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iotthingsgraph.upload_status.get upload_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iotthingsgraph",
        operation="get_upload_status",
        op_kwargs={"uploadId": upload_id},
    )
