"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def search(
    hub,
    ctx,
    entity_id: str,
    next_token: str = None,
    max_results: int = None,
    namespace_version: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Searches for things associated with the specified entity. You can search by both device and device model. For example, if two different devices, camera1 and camera2, implement the camera device model, the user can associate thing1 to camera1 and thing2 to camera2. SearchThings(camera2) will return only thing2, but SearchThings(camera) will return both thing1 and thing2. This action searches for exact matches and doesn't perform partial text matching.

    Args:
        entity_id(str): The ID of the entity to which the things are associated. The IDs should be in the following format.  urn:tdm:REGION/ACCOUNT ID/default:device:DEVICENAME .
        next_token(str, optional): The string that specifies the next page of results. Use this when you're paginating results. Defaults to None.
        max_results(int, optional): The maximum number of results to return in the response. Defaults to None.
        namespace_version(int, optional): The version of the user's namespace. Defaults to the latest version of the user's namespace. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iotthingsgraph.thing.search(ctx, entity_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iotthingsgraph.thing.search entity_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iotthingsgraph",
        operation="search_things",
        op_kwargs={
            "entityId": entity_id,
            "nextToken": next_token,
            "maxResults": max_results,
            "namespaceVersion": namespace_version,
        },
    )
