"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


__func_alias__ = {"list_": "list"}


async def list_(
    hub, ctx, resource_arn: str, max_results: int = None, next_token: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Lists all tags on an AWS IoT Things Graph resource.

    Args:
        max_results(int, optional): The maximum number of tags to return. Defaults to None.
        resource_arn(str): The Amazon Resource Name (ARN) of the resource whose tags are to be returned.
        next_token(str, optional): The token that specifies the next page of results to return. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iotthingsgraph.tags_for_resource.list(ctx, resource_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iotthingsgraph.tags_for_resource.list resource_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iotthingsgraph",
        operation="list_tags_for_resource",
        op_kwargs={
            "maxResults": max_results,
            "resourceArn": resource_arn,
            "nextToken": next_token,
        },
    )
