"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub, ctx, definition: Dict, compatible_namespace_version: int = None
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a system. The system is validated against the entities in the latest version of the user's namespace unless another namespace version is specified in the request.

    Args:
        definition(Dict): The DefinitionDocument used to create the system.
        compatible_namespace_version(int, optional): The namespace version in which the system is to be created. If no value is specified, the latest version is used by default. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iotthingsgraph.system.template.init.create(
                ctx, definition=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iotthingsgraph.system.template.init.create definition=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iotthingsgraph",
        operation="create_system_template",
        op_kwargs={
            "definition": definition,
            "compatibleNamespaceVersion": compatible_namespace_version,
        },
    )


async def delete(hub, ctx, id_: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes a system. New deployments can't contain the system after its deletion. Existing deployments that contain the system will continue to work because they use a snapshot of the system that is taken when it is deployed.

    Args:
        id_(str): The ID of the system to be deleted. The ID should be in the following format.  urn:tdm:REGION/ACCOUNT ID/default:system:SYSTEMNAME .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iotthingsgraph.system.template.init.delete(ctx, id_=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iotthingsgraph.system.template.init.delete id_=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iotthingsgraph",
        operation="delete_system_template",
        op_kwargs={"id": id_},
    )


async def deprecate(hub, ctx, id_: str) -> Dict:
    r"""
    **Autogenerated function**

    Deprecates the specified system.

    Args:
        id_(str): The ID of the system to delete. The ID should be in the following format.  urn:tdm:REGION/ACCOUNT ID/default:system:SYSTEMNAME .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iotthingsgraph.system.template.init.deprecate(ctx, id_=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iotthingsgraph.system.template.init.deprecate id_=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iotthingsgraph",
        operation="deprecate_system_template",
        op_kwargs={"id": id_},
    )


async def get(hub, ctx, id_: str, revision_number: int = None) -> Dict:
    r"""
    **Autogenerated function**

    Gets a system.

    Args:
        id_(str): The ID of the system to get. This ID must be in the user's namespace. The ID should be in the following format.  urn:tdm:REGION/ACCOUNT ID/default:system:SYSTEMNAME .
        revision_number(int, optional): The number that specifies the revision of the system to get. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iotthingsgraph.system.template.init.get(ctx, id_=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iotthingsgraph.system.template.init.get id_=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iotthingsgraph",
        operation="get_system_template",
        op_kwargs={"id": id_, "revisionNumber": revision_number},
    )


async def search(
    hub, ctx, filters: List = None, next_token: str = None, max_results: int = None
) -> Dict:
    r"""
    **Autogenerated function**

    Searches for summary information about systems in the user's account. You can filter by the ID of a workflow to return only systems that use the specified workflow.

    Args:
        filters(List, optional): An array of filters that limit the result set. The only valid filter is FLOW_TEMPLATE_ID. Defaults to None.
        next_token(str, optional): The string that specifies the next page of results. Use this when you're paginating results. Defaults to None.
        max_results(int, optional): The maximum number of results to return in the response. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iotthingsgraph.system.template.init.search(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iotthingsgraph.system.template.init.search
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iotthingsgraph",
        operation="search_system_templates",
        op_kwargs={
            "filters": filters,
            "nextToken": next_token,
            "maxResults": max_results,
        },
    )


async def update(
    hub, ctx, id_: str, definition: Dict, compatible_namespace_version: int = None
) -> Dict:
    r"""
    **Autogenerated function**

    Updates the specified system. You don't need to run this action after updating a workflow. Any deployment that uses the system will see the changes in the system when it is redeployed.

    Args:
        id_(str): The ID of the system to be updated. The ID should be in the following format.  urn:tdm:REGION/ACCOUNT ID/default:system:SYSTEMNAME .
        definition(Dict): The DefinitionDocument that contains the updated system definition.
        compatible_namespace_version(int, optional): The version of the user's namespace. Defaults to the latest version of the user's namespace. If no value is specified, the latest version is used by default. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iotthingsgraph.system.template.init.update(
                ctx, id_=value, definition=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iotthingsgraph.system.template.init.update id_=value, definition=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iotthingsgraph",
        operation="update_system_template",
        op_kwargs={
            "id": id_,
            "definition": definition,
            "compatibleNamespaceVersion": compatible_namespace_version,
        },
    )
