"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    definition: Dict,
    target: str,
    tags: List = None,
    greengrass_group_name: str = None,
    s3_bucket_name: str = None,
    metrics_configuration: Dict = None,
    flow_actions_role_arn: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a system instance.  This action validates the system instance, prepares the deployment-related resources. For Greengrass deployments, it updates the Greengrass group that is specified by the greengrassGroupName parameter. It also adds a file to the S3 bucket specified by the s3BucketName parameter. You need to call DeploySystemInstance after running this action. For Greengrass deployments, since this action modifies and adds resources to a Greengrass group and an S3 bucket on the caller's behalf, the calling identity must have write permissions to both the specified Greengrass group and S3 bucket. Otherwise, the call will fail with an authorization error. For cloud deployments, this action requires a flowActionsRoleArn value. This is an IAM role that has permissions to access AWS services, such as AWS Lambda and AWS IoT, that the flow uses when it executes. If the definition document doesn't specify a version of the user's namespace, the latest version will be used by default.

    Args:
        tags(List, optional): Metadata, consisting of key-value pairs, that can be used to categorize your system instances. Defaults to None.
        definition(Dict): A document that defines an entity. .
        target(str): The target type of the deployment. Valid values are GREENGRASS and CLOUD.
        greengrass_group_name(str, optional): The name of the Greengrass group where the system instance will be deployed. This value is required if the value of the target parameter is GREENGRASS. Defaults to None.
        s3_bucket_name(str, optional): The name of the Amazon Simple Storage Service bucket that will be used to store and deploy the system instance's resource file. This value is required if the value of the target parameter is GREENGRASS. Defaults to None.
        metrics_configuration(Dict, optional): An object that specifies whether cloud metrics are collected in a deployment and, if so, what role is used to collect metrics. Defaults to None.
        flow_actions_role_arn(str, optional): The ARN of the IAM role that AWS IoT Things Graph will assume when it executes the flow. This role must have read and write access to AWS Lambda and AWS IoT and any other AWS services that the flow uses when it executes. This value is required if the value of the target parameter is CLOUD. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iotthingsgraph.system.instance.create(
                ctx, definition=value, target=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iotthingsgraph.system.instance.create definition=value, target=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iotthingsgraph",
        operation="create_system_instance",
        op_kwargs={
            "tags": tags,
            "definition": definition,
            "target": target,
            "greengrassGroupName": greengrass_group_name,
            "s3BucketName": s3_bucket_name,
            "metricsConfiguration": metrics_configuration,
            "flowActionsRoleArn": flow_actions_role_arn,
        },
    )


async def delete(hub, ctx, id_: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Deletes a system instance. Only system instances that have never been deployed, or that have been undeployed can be deleted. Users can create a new system instance that has the same ID as a deleted system instance.

    Args:
        id_(str, optional): The ID of the system instance to be deleted. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iotthingsgraph.system.instance.delete(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iotthingsgraph.system.instance.delete
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iotthingsgraph",
        operation="delete_system_instance",
        op_kwargs={"id": id_},
    )


async def deploy(hub, ctx, id_: str = None) -> Dict:
    r"""
    **Autogenerated function**

     Greengrass and Cloud Deployments  Deploys the system instance to the target specified in CreateSystemInstance.   Greengrass Deployments  If the system or any workflows and entities have been updated before this action is called, then the deployment will create a new Amazon Simple Storage Service resource file and then deploy it. Since this action creates a Greengrass deployment on the caller's behalf, the calling identity must have write permissions to the specified Greengrass group. Otherwise, the call will fail with an authorization error. For information about the artifacts that get added to your Greengrass core device when you use this API, see AWS IoT Things Graph and AWS IoT Greengrass.

    Args:
        id_(str, optional): The ID of the system instance. This value is returned by the CreateSystemInstance action. The ID should be in the following format.  urn:tdm:REGION/ACCOUNT ID/default:deployment:DEPLOYMENTNAME . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iotthingsgraph.system.instance.deploy(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iotthingsgraph.system.instance.deploy
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iotthingsgraph",
        operation="deploy_system_instance",
        op_kwargs={"id": id_},
    )


async def get(hub, ctx, id_: str) -> Dict:
    r"""
    **Autogenerated function**

    Gets a system instance.

    Args:
        id_(str): The ID of the system deployment instance. This value is returned by CreateSystemInstance. The ID should be in the following format.  urn:tdm:REGION/ACCOUNT ID/default:deployment:DEPLOYMENTNAME .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iotthingsgraph.system.instance.get(ctx, id_=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iotthingsgraph.system.instance.get id_=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iotthingsgraph",
        operation="get_system_instance",
        op_kwargs={"id": id_},
    )


async def search(
    hub, ctx, filters: List = None, next_token: str = None, max_results: int = None
) -> Dict:
    r"""
    **Autogenerated function**

    Searches for system instances in the user's account.

    Args:
        filters(List, optional): Optional filter to apply to the search. Valid filters are SYSTEM_TEMPLATE_ID, STATUS, and GREENGRASS_GROUP_NAME. Multiple filters function as OR criteria in the query. Multiple values passed inside the filter function as AND criteria. Defaults to None.
        next_token(str, optional): The string that specifies the next page of results. Use this when you're paginating results. Defaults to None.
        max_results(int, optional): The maximum number of results to return in the response. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iotthingsgraph.system.instance.search(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iotthingsgraph.system.instance.search
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iotthingsgraph",
        operation="search_system_instances",
        op_kwargs={
            "filters": filters,
            "nextToken": next_token,
            "maxResults": max_results,
        },
    )


async def undeploy(hub, ctx, id_: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Removes a system instance from its target (Cloud or Greengrass).

    Args:
        id_(str, optional): The ID of the system instance to remove from its target. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iotthingsgraph.system.instance.undeploy(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iotthingsgraph.system.instance.undeploy
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iotthingsgraph",
        operation="undeploy_system_instance",
        op_kwargs={"id": id_},
    )
