"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub, ctx, definition: Dict, compatible_namespace_version: int = None
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a workflow template. Workflows can be created only in the user's namespace. (The public namespace contains only entities.) The workflow can contain only entities in the specified namespace. The workflow is validated against the entities in the latest version of the user's namespace unless another namespace version is specified in the request.

    Args:
        definition(Dict): The workflow DefinitionDocument.
        compatible_namespace_version(int, optional): The namespace version in which the workflow is to be created. If no value is specified, the latest version is used by default. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iotthingsgraph.flow.template.init.create(ctx, definition=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iotthingsgraph.flow.template.init.create definition=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iotthingsgraph",
        operation="create_flow_template",
        op_kwargs={
            "definition": definition,
            "compatibleNamespaceVersion": compatible_namespace_version,
        },
    )


async def delete(hub, ctx, id_: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes a workflow. Any new system or deployment that contains this workflow will fail to update or deploy. Existing deployments that contain the workflow will continue to run (since they use a snapshot of the workflow taken at the time of deployment).

    Args:
        id_(str): The ID of the workflow to be deleted. The ID should be in the following format.  urn:tdm:REGION/ACCOUNT ID/default:workflow:WORKFLOWNAME .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iotthingsgraph.flow.template.init.delete(ctx, id_=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iotthingsgraph.flow.template.init.delete id_=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iotthingsgraph",
        operation="delete_flow_template",
        op_kwargs={"id": id_},
    )


async def deprecate(hub, ctx, id_: str) -> Dict:
    r"""
    **Autogenerated function**

    Deprecates the specified workflow. This action marks the workflow for deletion. Deprecated flows can't be deployed, but existing deployments will continue to run.

    Args:
        id_(str): The ID of the workflow to be deleted. The ID should be in the following format.  urn:tdm:REGION/ACCOUNT ID/default:workflow:WORKFLOWNAME .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iotthingsgraph.flow.template.init.deprecate(ctx, id_=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iotthingsgraph.flow.template.init.deprecate id_=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iotthingsgraph",
        operation="deprecate_flow_template",
        op_kwargs={"id": id_},
    )


async def get(hub, ctx, id_: str, revision_number: int = None) -> Dict:
    r"""
    **Autogenerated function**

    Gets the latest version of the DefinitionDocument and FlowTemplateSummary for the specified workflow.

    Args:
        id_(str): The ID of the workflow. The ID should be in the following format.  urn:tdm:REGION/ACCOUNT ID/default:workflow:WORKFLOWNAME .
        revision_number(int, optional): The number of the workflow revision to retrieve. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iotthingsgraph.flow.template.init.get(ctx, id_=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iotthingsgraph.flow.template.init.get id_=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iotthingsgraph",
        operation="get_flow_template",
        op_kwargs={"id": id_, "revisionNumber": revision_number},
    )


async def search(
    hub, ctx, filters: List = None, next_token: str = None, max_results: int = None
) -> Dict:
    r"""
    **Autogenerated function**

    Searches for summary information about workflows.

    Args:
        filters(List, optional): An array of objects that limit the result set. The only valid filter is DEVICE_MODEL_ID. Defaults to None.
        next_token(str, optional): The string that specifies the next page of results. Use this when you're paginating results. Defaults to None.
        max_results(int, optional): The maximum number of results to return in the response. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iotthingsgraph.flow.template.init.search(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iotthingsgraph.flow.template.init.search
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iotthingsgraph",
        operation="search_flow_templates",
        op_kwargs={
            "filters": filters,
            "nextToken": next_token,
            "maxResults": max_results,
        },
    )


async def update(
    hub, ctx, id_: str, definition: Dict, compatible_namespace_version: int = None
) -> Dict:
    r"""
    **Autogenerated function**

    Updates the specified workflow. All deployed systems and system instances that use the workflow will see the changes in the flow when it is redeployed. If you don't want this behavior, copy the workflow (creating a new workflow with a different ID), and update the copy. The workflow can contain only entities in the specified namespace.

    Args:
        id_(str): The ID of the workflow to be updated. The ID should be in the following format.  urn:tdm:REGION/ACCOUNT ID/default:workflow:WORKFLOWNAME .
        definition(Dict): The DefinitionDocument that contains the updated workflow definition.
        compatible_namespace_version(int, optional): The version of the user's namespace. If no value is specified, the latest version is used by default. Use the GetFlowTemplateRevisions if you want to find earlier revisions of the flow to update. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iotthingsgraph.flow.template.init.update(
                ctx, id_=value, definition=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iotthingsgraph.flow.template.init.update id_=value, definition=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iotthingsgraph",
        operation="update_flow_template",
        op_kwargs={
            "id": id_,
            "definition": definition,
            "compatibleNamespaceVersion": compatible_namespace_version,
        },
    )
