"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def list_all(
    hub, ctx, flow_execution_id: str, next_token: str = None, max_results: int = None
) -> Dict:
    r"""
    **Autogenerated function**

    Returns a list of objects that contain information about events in a flow execution.

    Args:
        flow_execution_id(str): The ID of the flow execution.
        next_token(str, optional): The string that specifies the next page of results. Use this when you're paginating results. Defaults to None.
        max_results(int, optional): The maximum number of results to return in the response. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iotthingsgraph.flow.execution.message.list_all(
                ctx, flow_execution_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iotthingsgraph.flow.execution.message.list_all flow_execution_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iotthingsgraph",
        operation="list_flow_execution_messages",
        op_kwargs={
            "flowExecutionId": flow_execution_id,
            "nextToken": next_token,
            "maxResults": max_results,
        },
    )
