"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def search(
    hub,
    ctx,
    system_instance_id: str,
    flow_execution_id: str = None,
    start_time: str = None,
    end_time: str = None,
    next_token: str = None,
    max_results: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Searches for AWS IoT Things Graph workflow execution instances.

    Args:
        system_instance_id(str): The ID of the system instance that contains the flow.
        flow_execution_id(str, optional): The ID of a flow execution. Defaults to None.
        start_time(str, optional): The date and time of the earliest flow execution to return. Defaults to None.
        end_time(str, optional): The date and time of the latest flow execution to return. Defaults to None.
        next_token(str, optional): The string that specifies the next page of results. Use this when you're paginating results. Defaults to None.
        max_results(int, optional): The maximum number of results to return in the response. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iotthingsgraph.flow.execution.init.search(
                ctx, system_instance_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iotthingsgraph.flow.execution.init.search system_instance_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iotthingsgraph",
        operation="search_flow_executions",
        op_kwargs={
            "systemInstanceId": system_instance_id,
            "flowExecutionId": flow_execution_id,
            "startTime": start_time,
            "endTime": end_time,
            "nextToken": next_token,
            "maxResults": max_results,
        },
    )
