"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def associate(
    hub, ctx, thing_name: str, entity_id: str, namespace_version: int = None
) -> Dict:
    r"""
    **Autogenerated function**

    Associates a device with a concrete thing that is in the user's registry. A thing can be associated with only one device at a time. If you associate a thing with a new device id, its previous association will be removed.

    Args:
        thing_name(str): The name of the thing to which the entity is to be associated.
        entity_id(str): The ID of the device to be associated with the thing. The ID should be in the following format.  urn:tdm:REGION/ACCOUNT ID/default:device:DEVICENAME .
        namespace_version(int, optional): The version of the user's namespace. Defaults to the latest version of the user's namespace. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iotthingsgraph.entity.to_thing.associate(
                ctx, thing_name=value, entity_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iotthingsgraph.entity.to_thing.associate thing_name=value, entity_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iotthingsgraph",
        operation="associate_entity_to_thing",
        op_kwargs={
            "thingName": thing_name,
            "entityId": entity_id,
            "namespaceVersion": namespace_version,
        },
    )
