"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def get_all(hub, ctx, ids: List, namespace_version: int = None) -> Dict:
    r"""
    **Autogenerated function**

    Gets definitions of the specified entities. Uses the latest version of the user's namespace by default. This API returns the following TDM entities.   Properties   States   Events   Actions   Capabilities   Mappings   Devices   Device Models   Services   This action doesn't return definitions for systems, flows, and deployments.

    Args:
        ids(List): An array of entity IDs. The IDs should be in the following format.  urn:tdm:REGION/ACCOUNT ID/default:device:DEVICENAME .
        namespace_version(int, optional): The version of the user's namespace. Defaults to the latest version of the user's namespace. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iotthingsgraph.entity.init.get_all(ctx, ids=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iotthingsgraph.entity.init.get_all ids=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iotthingsgraph",
        operation="get_entities",
        op_kwargs={"ids": ids, "namespaceVersion": namespace_version},
    )


async def search(
    hub,
    ctx,
    entity_types: List,
    filters: List = None,
    next_token: str = None,
    max_results: int = None,
    namespace_version: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Searches for entities of the specified type. You can search for entities in your namespace and the public namespace that you're tracking.

    Args:
        entity_types(List): The entity types for which to search.
        filters(List, optional): Optional filter to apply to the search. Valid filters are NAME NAMESPACE, SEMANTIC_TYPE_PATH and REFERENCED_ENTITY_ID. REFERENCED_ENTITY_ID filters on entities that are used by the entity in the result set. For example, you can filter on the ID of a property that is used in a state. Multiple filters function as OR criteria in the query. Multiple values passed inside the filter function as AND criteria. Defaults to None.
        next_token(str, optional): The string that specifies the next page of results. Use this when you're paginating results. Defaults to None.
        max_results(int, optional): The maximum number of results to return in the response. Defaults to None.
        namespace_version(int, optional): The version of the user's namespace. Defaults to the latest version of the user's namespace. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iotthingsgraph.entity.init.search(ctx, entity_types=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iotthingsgraph.entity.init.search entity_types=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iotthingsgraph",
        operation="search_entities",
        op_kwargs={
            "entityTypes": entity_types,
            "filters": filters,
            "nextToken": next_token,
            "maxResults": max_results,
            "namespaceVersion": namespace_version,
        },
    )
