"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def dissociate(hub, ctx, thing_name: str, entity_type: str) -> Dict:
    r"""
    **Autogenerated function**

    Dissociates a device entity from a concrete thing. The action takes only the type of the entity that you need to dissociate because only one entity of a particular type can be associated with a thing.

    Args:
        thing_name(str): The name of the thing to disassociate.
        entity_type(str): The entity type from which to disassociate the thing.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iotthingsgraph.entity.from_thing.dissociate(
                ctx, thing_name=value, entity_type=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iotthingsgraph.entity.from_thing.dissociate thing_name=value, entity_type=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iotthingsgraph",
        operation="dissociate_entity_from_thing",
        op_kwargs={"thingName": thing_name, "entityType": entity_type},
    )
